function doPost(e) {
  try {
    var sheet = SpreadsheetApp.openById(
      "1ftAEpfBLr64EETAv1Rvj2fiT8wm38WAwVafv0bhjiRs"
    ).getActiveSheet();
    var data = JSON.parse(e.postData.contents);

    // Insert data into the sheet
    sheet.appendRow([
      new Date(),
      data.fullName || "",
      data.email || "",
      data.phone || "",
      data.currentRole || "",
      data.certificationTrack || "",
      data.experience || "",
      data.motivation || "",
      data.paymentMethod || "",
      data.specialRequirements || "",
    ]);

    // Return success response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "success",
        message: "Certification enrollment submitted!",
      })
    ).setMimeType(ContentService.MimeType.JSON);
  } catch (error) {
    console.error("Error in Certification Form doPost:", error);

    // Return error response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "error",
        message: "Certification enrollment failed: " + error.toString(),
      })
    ).setMimeType(ContentService.MimeType.JSON);
  }
}

/* 
Google Sheet Headers (Row 1):
Timestamp | Full Name | Email | Phone | Current Role | Certification Track | Experience | Motivation | Payment Method | Special Requirements

Deploy Settings:
- Execute as: Me
- Who has access: Anyone
- Copy the deployment URL and replace YOUR_CERTIFICATION_APPS_SCRIPT_URL in the JavaScript
*/
